*Create uncertainty.dta used for analysis

local location "<place directory here>" 


use "`location'\Unbalanced.dta" , clear 


*tostring xwaveid , g(waveid)
*gen str7 z = string(xwaveid,"%07.0f")
*rename xwaveid waveid 
*rename z xwaveid 

*Weights
g hwt_noadj =  hhwth
g hwt_adj = hhwthm 

g hwt_new = hwt_noadj
replace hwt_new = hwt_adj if hwt_noadj == 0


g female = (hgsex == 2)

g dinc = hifditp -hifditn
g ldinc = log(dinc)

g winc = hiwsfei
g lwinc = log(winc)
  
  
g age = hgage
g agesq= age*age


g hsize = hhpers
g lhsize = log(hsize)

g adults = hhadult 
g persons = hhpers
g kids = persons-adults 


*JOB CHARACTERISTICS 

g emp = (esbrd==1)

g selfemp =  (esempst>1)
replace selfemp = . if esempst==.
g employee = (esempst==1)

g parttime = (hges ==2)
g fulltime = (hges ==1)

g casual = (jbmcnt==2)
g permanent = (jbmcnt==3)
g fixedterm = (jbmcnt == 1)

g jtenure = jbempt
replace jtenure = . if jtenure < 0

g jtenuresq = jtenure*jtenure 

g occupation = jbmo06
replace occupation = . if occupation < 0
 
g size = jbmwpsz
replace size = . if size < 0
g small = (size < 4)
replace small = . if size == .

g supervisor = (jbmsvsr==1)
 
*INDUSTRY OF EMPLOYMENT  
g division = jbmi61 
g industry = jbmi62
replace division = . if division< 0
replace industry = . if industry < 0


*Local unemployment
g urate = hhura
replace urate = urate/100
replace urate = . if urate < 0

*Education 
g uni = (edhigh1> 0 & edhigh1 < 4)
g tafe = (edhigh1> 3 & edhigh1 < 8)
g school = (edhigh1> 5 & edhigh1 < 10)


*Health condition 
g healthprob = (hglth== 1)
g healthprob2 = (helth== 1)

drop if age > 80
drop if age < 18
  
egen id = group(xwaveid)
tsset id year 
*Estimate regression for log of wage income
areg lwinc i.age parttime casual fixedterm supervisor uni tafe urate healthprob i.occupation jtenure jtenuresq i.year, a(industry)
predict lwinc_res, res 
*Estimate regression for log of disposable income
areg ldinc i.age employee selfemp parttime casual fixedterm supervisor uni tafe urate healthprob i.occupation jtenure jtenuresq i.year, a(industry)
predict ldinc_res, res 
  
*Estimate rolling SD using 3-year window for each type of income 
bys xwaveid: asrol lwinc_res, stat(sd) window(year 3) 
bys xwaveid: asrol ldinc_res, stat(sd) window(year 3) 

tsset id year 
gen lwinc_res_m = (lwinc_res + l1.lwinc_res  + l2.lwinc_res)/3
gen s = (lwinc_res-lwinc_res_m)^2 + (l1.lwinc_res-lwinc_res_m)^2 + (l2.lwinc_res-lwinc_res_m)^2  
gen sd = sqrt(s/3)

su sd lwinc_res_sd 

*Check the time-series
preserve 
collapse(mean) lwinc_res_sd ldinc_res_sd [aw = hwt_new], by(year)
twoway (line lwinc year ) (line ldinc year )
restore 

*PQ: Percent chance of losing job in next 12 months
g ejobloss = jbmploj
replace ejobloss = . if jbmploj > 100
replace ejobloss = . if jbmploj < 0
replace ejobloss = ejobloss/100

rename lwinc_res_sd wuncertainty 
rename ldinc_res_sd uncertainty 
*Seems pretty highly correlated...
xtreg ejobloss wuncertainty age agesq i.year, cl(xwaveid) fe

rename hhwte pwt 
preserve
xtile wuncertainty_nq = wuncertainty [aw = pwt], nq(10)
collapse(mean) ejobloss wuncertainty , by(wuncertainty_nq)
twoway line ejobloss wuncertainty_nq 
restore  

tsset id year 
g wgrowth = d.lwinc
g igrowth = d.ldinc 

preserve 
keep wuncertainty uncertainty xwaveid year wgrowth igrowth 
save "`location'\uncertainty.dta", replace 
restore 
